CREATE TABLE kundanfstat
  (kanfs_status         VARCHAR(5) PRIMARY KEY,
   kanfs_bez            VARCHAR(200),
   kanfs_isService      BOOLEAN NOT NULL DEFAULT FALSE
  );

   /* Die Status L - Laufende, A - Ausschreibung (KA) und NEU (SA) dürfen nicht verändert werden, weil diese in den Assistenten verwendet werden */
  CREATE OR REPLACE FUNCTION kundanfstat__a_du() RETURNS TRIGGER AS $$
    BEGIN
     RAISE EXCEPTION 'xtt15710';
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER kundanfstat__a_du
    BEFORE DELETE OR UPDATE
    OF kanfs_status
    ON kundanfstat
    FOR EACH ROW
    WHEN (old.kanfs_status IN ('A','L','NEU'))
    EXECUTE PROCEDURE kundanfstat__a_du();

-- Priorität
CREATE TABLE kundanfprio
  (kanfpr_prio          VARCHAR(20) PRIMARY KEY,
   kanfpr_bez           VARCHAR(200),
   kanfpr_isService     BOOLEAN NOT NULL DEFAULT FALSE
  );

  /* Die Status 1-3 dürfen nicht verändert werden, weil diese in den Assistenten verwendet werden */
  CREATE OR REPLACE FUNCTION kundanfprio__a_du() RETURNS TRIGGER AS $$
   BEGIN
    RAISE EXCEPTION 'xtt15694';
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER kundanfprio__a_du
    BEFORE DELETE OR UPDATE
    OF kanfpr_prio
    ON kundanfprio
    FOR EACH ROW
    WHEN (old.kanfpr_prio IN ('s1','s2','s3','k1','k2','k3'))
    EXECUTE PROCEDURE kundanfprio__a_du();

-- Realisierungswahrscheinlichkeit #6679
CREATE TABLE kanfwsk
  (kanfwsk_wsk          varchar(20) PRIMARY KEY,
   kanfwsk_bez          varchar(200)
  );

 --- # 6679 Erweiterung Interessentenverwaltung
 CREATE OR REPLACE FUNCTION kanf_get_wskbez(IN _kanfwsk_wsk varchar)
  RETURNS varchar
  AS $$
      SELECT kanfwsk_bez FROM kanfwsk WHERE kanfwsk_wsk = _kanfwsk_wsk;
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;



-- Anfrageart
CREATE TABLE kundanfart
  (kanfart_status       VARCHAR(5) PRIMARY KEY,
   kanfart_bez          VARCHAR(200),
   kanfart_isService    BOOLEAN NOT NULL DEFAULT FALSE
  );

 /* Status A darf nicht verändert werden, weil in den Assistenten verwendet */
    CREATE OR REPLACE FUNCTION kundanfart__a_du() RETURNS TRIGGER AS $$
    BEGIN
     RAISE EXCEPTION 'xtt15925';
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER kundanfart__a_du
    BEFORE DELETE OR UPDATE
    OF kanfart_status
    ON kundanfart
    FOR EACH ROW
    WHEN (old.kanfart_status IN ('A'))
    EXECUTE PROCEDURE kundanfart__a_du();


-- Absagegrund-Gruppe
CREATE TABLE kundabs
  (kanfa_grup           VARCHAR(20) PRIMARY KEY,
   kanfa_bez            VARCHAR(200),
   kanfa_isService      BOOLEAN NOT NULL DEFAULT FALSE,
   kanfa_isInteres      BOOLEAN NOT NULL DEFAULT FALSE,
   kanfa_isAngebot      BOOLEAN NOT NULL DEFAULT FALSE
  );

-- Herkunfts-Gruppe
CREATE TABLE kundhkg
  (kanfh_grup           VARCHAR(20) PRIMARY KEY,
   kanfh_bez            VARCHAR(200),
   kanfh_isService      BOOLEAN NOT NULL DEFAULT FALSE
  );

-- Gesendet via
CREATE TABLE kundgv
    (kanfv_via          VARCHAR(20) PRIMARY KEY,
     kanfv_bez          VARCHAR(200),
     kanfv_isService    BOOLEAN NOT NULL DEFAULT FALSE
  );

-- Ergebnis der Ausschreibung
CREATE TABLE kundaerg
    (kanfe_erg          VARCHAR(20) PRIMARY KEY,
     kanfe_bez          VARCHAR(200),
     kanfe_isService    BOOLEAN NOT NULL DEFAULT FALSE
    );


--Kundenanfragen als Vorstufe zu konkretem Angebot

CREATE TABLE kundanfrage                                -- Kundenanfragen nach Produkten der eigenen Firma
 (kanf_nr               VARCHAR(20) PRIMARY KEY,
  kanf_date             DATE DEFAULT current_date,      -- Erfassungs/Eingangsdatum
  kanf_isService        BOOLEAN NOT NULL DEFAULT FALSE,  --Zur Unterscheidung von Sericeanfrage und Kundenanfrage
  kanf_ag_id            INTEGER REFERENCES auftg,       -- Auftrag welche sich auf die Serviceanfrage bezieht
  kanf_ld_id            INTEGER, --REFERENCES ldsdok,   -- Einkauf welche sich auf die Serviceanfrage bezieht
  kanf_ak_nr            VARCHAR(40) REFERENCES art ON UPDATE CASCADE, --Falls weder Einkauf, Verkauf noch Projekt bekannt, weiß der Kunde zumindest für welchen Artikel er einen Garantiefall hat
  kanf_txt              TEXT,                           -- Freier Text in Anfragekopfdaten
  kanf_txt_rtf          TEXT,
  kanf_erreichbar       VARCHAR(200),                   --Freitext für Erreichbarkeit des Kunden
  kanf_apkrzl           VARCHAR(10),
  kanf_ap               VARCHAR(50),                    --Allgemein, zusätzlicher Ansprechpartner - bei Sunstrom Eigentümer/Bauherr
  kanf_api              VARCHAR(20),                    --Interner Ansprechpartner
  kanf_ad_krz           VARCHAR(21) REFERENCES adk ON UPDATE CASCADE,
  kanf_krzl             VARCHAR(30) REFERENCES adressen_keys ON UPDATE CASCADE, --Lieferadresse
  kanf_status           VARCHAR(5) REFERENCES kundanfstat ON UPDATE CASCADE,
  kanf_art              VARCHAR(5) REFERENCES kundanfart ON UPDATE CASCADE, --Art der Anfrage
  kanf_via              VARCHAR(200),                   --Anfrage durch
  kanf_viabem           TEXT,                           --Anfrgae durch Bemerkung
  kanf_verm             VARCHAR(21) REFERENCES adk ON UPDATE CASCADE, -- Vermittler ..."zu uns durch"
  kanf_praemie          BOOL DEFAULT FALSE,             -- Prämie zahlen
  kanf_iba              DATE,                           -- Informationsbogen abgesendet
  kanf_ibgd             VARCHAR(20),                    -- Informationsbogen abgesendet durch
  kanf_ibgv             VARCHAR(20) REFERENCES kundgv ON UPDATE CASCADE, -- Informationsbogen abgesendet via
  kanf_ibz              DATE,                           -- Informationsbogen zurück
  kanf_ausedate         DATE,                           -- Auschreibung eingegangen am
  kanf_ausfdate         DATE,                           -- Datum Auschreibung Fertigstellung
  kanf_aussubdate       DATE,                           -- Datum Ausschreibung Submission
  kanf_ausgdate         DATE,                           -- Datum Ausschreibung gesendet
  kanf_auserg           VARCHAR(20) REFERENCES kundaerg ON UPDATE CASCADE, -- Ergebnis der Auschreibung
  kanf_ebem             TEXT,                           -- Ergebnis Ausschreibung Bemerkung
  kanf_prio             VARCHAR(20) REFERENCES kundanfprio ON UPDATE CASCADE, -- Priorität
  kanf_bemobj           TEXT,                           --Bemerkung zum Objekt
  kanf_gegenstand       VARCHAR(200),                   -- z.B. Leistung (kwp)
  kanf_hkgrup           VARCHAR(20) REFERENCES kundhkg ON UPDATE CASCADE, -- Herkunftsgruppe
  kanf_an_nr            VARCHAR(50) REFERENCES anl ON UPDATE CASCADE, -- Projekt-Nr
  kanf_wga              VARCHAR(20),                    -- weitergeleitet an
  kanf_ortterm          DATE,                           -- Vor-Ort-Beratung
  kanf_berd             VARCHAR(20),                    -- Beratung durch
  kanf_lnachdate        DATE,                           -- Letzte Nachfrage
  kanf_lnachd           VARCHAR(20),                    -- Letzte Nachfrage durch
  kanf_absdate          DATE,                           -- Datum Absage
  kanf_done             BOOL NOT NULL DEFAULT false,    --kanf_absdate, kanf_auserg
  kanf_storno           BOOL NOT NULL DEFAULT false,
  kanf_absgrup          VARCHAR(20) REFERENCES kundabs ON UPDATE CASCADE, -- Absage-Grund-Gruppe
  kanf_absage           TEXT,                           -- Grund der Absage
  kanf_bem              TEXT,                           -- Bemerkung
  kanf_refnummer        VARCHAR(40),                    -- #6679 Referenznummer
  kanf_kanfwsk_wsk      VARCHAR(20) REFERENCES kanfwsk ON UPDATE CASCADE        --  #6679 Realisierungswahrscheinlichkeit
 );


 CREATE TRIGGER kundanfrage_delete_abk_project_structure AFTER DELETE ON kundanfrage FOR EACH ROW EXECUTE PROCEDURE table_delete_abkstru();


 CREATE OR REPLACE FUNCTION kundanfrage__b_i() RETURNS TRIGGER AS $$
  BEGIN
   IF new.kanf_isService THEN
    new.kanf_status:=COALESCE(new.kanf_status,'L');
    ELSE
    new.kanf_status:=COALESCE(new.kanf_status,'NEU');
   END IF;
   --
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER kundanfrage__b_i
   BEFORE INSERT
   ON kundanfrage
   FOR EACH ROW
   EXECUTE PROCEDURE kundanfrage__b_i();



 CREATE OR REPLACE FUNCTION kundanfrage__b_iu() RETURNS TRIGGER AS $$
  BEGIN
   IF new.kanf_storno THEN
          new.kanf_done:=TRUE;
   END IF;
   IF (new.kanf_absdate IS NOT NULL OR new.kanf_auserg IS NOT NULL) AND NOT new.kanf_done THEN
          new.kanf_done:=TRUE;
   END IF;
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER kundanfrage__b_iu
   BEFORE INSERT OR UPDATE
   ON kundanfrage
   FOR EACH ROW
   EXECUTE PROCEDURE kundanfrage__b_iu();

 --
 CREATE OR REPLACE FUNCTION kundanfrage__a_iu__annr() RETURNS TRIGGER AS $$
  BEGIN
   PERFORM disablemodified();
   UPDATE abk SET ab_dbrid=ab_dbrid FROM kundservicepos WHERE kanfse_kanf_nr=new.kanf_nr AND kundservicepos.dbrid=ab_dbrid; -- >> abk__b_iu__tablenamedbrid
   UPDATE abk SET ab_dbrid=ab_dbrid FROM kundservicepos, qab WHERE kanfse_kanf_nr=new.kanf_nr AND q_kanfse_id=kanfse_id AND qab.dbrid=ab_dbrid;
   PERFORM enablemodified();
  RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER kundanfrage__a_iu__annr
   AFTER INSERT OR UPDATE
   OF kanf_an_nr
   ON kundanfrage
   FOR EACH ROW
   EXECUTE PROCEDURE kundanfrage__a_iu__annr();
  ---

 CREATE OR REPLACE FUNCTION kundanfrage__a_u() RETURNS TRIGGER AS $$
  BEGIN
   IF (new.kanf_art='A') AND (new.kanf_done) THEN -- Nur für Adressakquise
     UPDATE adk SET ad_auslauf=NULL FROM kundanfrage WHERE ad_krz = new.kanf_ad_krz;
   END IF;

   -- aktualisieren qab
   IF new.kanf_ak_nr IS DISTINCT FROM old.kanf_ak_nr THEN
      UPDATE qab SET q_ak_nr = new.kanf_ak_nr
        FROM kundservicepos
       WHERE q_kanfse_id = kanfse_id
         AND kanfse_kanf_nr = new.kanf_nr
         -- qab Artikelnummer aktualisieren, wenn sie gleich war. Damit Bearbeiter evtl was anderes eintragen kann, dann wird es nicht mehr geändert.
         AND nullif(q_ak_nr, old.kanf_ak_nr) IS null
      ;
   END IF;

   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER kundanfrage__a_u
   AFTER UPDATE
   ON kundanfrage
   FOR EACH ROW
   EXECUTE PROCEDURE kundanfrage__a_u();

--Liste der Servicefälle
CREATE TABLE kundservicepos
 (kanfse_id             SERIAL PRIMARY KEY,
  kanfse_parent_id      INTEGER,
  kanfse_pos            INTEGER NOT NULL,       -- Positionsnummer
  kanfse_sfall          VARCHAR(100) NOT NULL,  -- ServiceFall
  kanfse_bez            VARCHAR(100), --ServiceFall Bezeichnung // wird nicht genutzt derzeit
  kanfse_kanf_nr        VARCHAR(20) NOT NULL REFERENCES kundanfrage ON DELETE CASCADE ON UPDATE CASCADE,        -- Anfrage-ID
  kanfse_txt            TEXT,                           -- Positionszusatztext
  kanfse_txt_rtf        TEXT,
  kanfse_ag_id          INTEGER REFERENCES auftg ON UPDATE CASCADE ON DELETE SET NULL -- #8468 ID von auftg analog kundanfragepos
 );


 CREATE TRIGGER kundservicepos_delete_abk_project_structure AFTER DELETE ON kundservicepos FOR EACH ROW EXECUTE PROCEDURE table_delete_abkstru();

CREATE TABLE kundanfragepos                              --Liste angefragter Artikel
 (kanfp_id              SERIAL PRIMARY KEY,
  kanfp_pos             INTEGER         NOT NULL,       -- Positionsnummer in einer Anfrage
  kanfp_ak_nr           VARCHAR(40)     NOT NULL,       -- Nachgefragter Artikel
  kanfp_bez             VARCHAR(100),
  kanfp_kanf_nr         VARCHAR(20)     NOT NULL REFERENCES kundanfrage ON DELETE CASCADE ON UPDATE CASCADE,    -- Anfrage-ID
  kanfp_menge           NUMERIC(12,4)   NOT NULL,       -- Gewünschte Menge
  kanfp_m_id            INTEGER         NOT NULL REFERENCES mgcode,     -- Mengeneinheit für Artikel
  kanfp_angnr           VARCHAR(20),                    -- Angebotsnr. aus Auftg, falls schon eines unterbreitet wurde
  kanfp_preis           NUMERIC(12,2),                  -- Vorläufiger Preis
  kanfp_termin          DATE,                           -- Gewünschter Liefertermin / Realisierung für Projektteil
  kanfp_txt             TEXT,                           -- Positionszusatztext
  kanfp_txt_rtf         TEXT,
  kanfp_kein_ang        BOOLEAN NOT NULL DEFAULT FALSE,                 -- #6679 Position-'Kein Angebot erstellen'
  kanfp_prio VARCHAR(20) REFERENCES kundanfprio ON UPDATE CASCADE,      -- #6679 Position-Priorität
  kanfp_status VARCHAR(5) REFERENCES kundanfstat ON UPDATE CASCADE,     -- #6679 Position-Status
  kanfp_ag_id           INTEGER         REFERENCES auftg ON UPDATE CASCADE ON DELETE SET NULL -- #7686 ID von auftg
 );
 ---

CREATE TABLE vpbt
  (vp_id                serial PRIMARY KEY,
   vp_prkl              integer NOT NULL,
   vp_kukl              integer NOT NULL,
   vp_bez               varchar(50),
   vp_txt               text,
   vp_acns_enum         varchar(150), -- kommaseparierte Spalte als Filter
   /*vp_ref             integer NOT NULL,*/
   vp_rucod             integer NOT NULL DEFAULT 0,
   vp_fixv              numeric,
   vp_proz              numeric,
   vp_fixn              numeric
  );

 CREATE UNIQUE INDEX vpbt_uindex ON vpbt (vp_prkl, vp_kukl);

CREATE TABLE vpbt_rund
  (vpr_id               SERIAL PRIMARY KEY,
   vpr_vp_id            INTEGER NOT NULL REFERENCES vpbt ON DELETE CASCADE,
   vpr_rund             NUMERIC,
   vpr_preis            NUMERIC
  );

-- Bearbeitsungsstatus im Auftrag und auch im Lieferschein (belegpos)!
CREATE TABLE auftgbs
  (as_bstat             VARCHAR(2) PRIMARY KEY,
   as_bbez              VARCHAR(50)
  );

CREATE TABLE auftgtxt(
   at_id                serial PRIMARY KEY,
   at_astat             varchar(1),
   at_nr                varchar(30),
   at_txt               text,
   at_txt_rtf           text,

   -- Referenz auf Kopfdatensatz angebot, damit man sich von dort über stat + nr positionen holen kann
   at_ang_at_id         integer REFERENCES auftgtxt,

   -- DROP
   at_fixwert           numeric(12,4),

   -- Gesamtrabatt im Verkauf  DROP
   at_gesrab            numeric(5,2) NOT NULL DEFAULT 0
 );

 CREATE UNIQUE INDEX auftgtxt_nr ON auftgtxt(at_astat, at_nr);
 CREATE UNIQUE INDEX auftgtxt_nr_like ON auftgtxt(at_astat varchar_pattern_ops, at_nr varchar_pattern_ops);

 CREATE TRIGGER auftgtxt_delete_abk_project_structure AFTER DELETE ON auftgtxt FOR EACH ROW EXECUTE PROCEDURE table_delete_abkstru();

 CREATE OR REPLACE FUNCTION auftgtxt__b_i() RETURNS TRIGGER AS $$
 BEGIN
    --Bei doppeltem Insert auf eine Bestellung verwerfen (Kann im alten Prodat passieren)
    IF NOT EXISTS(SELECT true FROM auftgtxt WHERE at_astat=new.at_astat AND at_nr=new.at_nr) THEN
        RETURN new;
    ELSE
        RETURN NULL;
    END IF;
    --
 END$$LANGUAGE plpgsql;

 CREATE TRIGGER auftgtxt__b_i
  BEFORE INSERT
  ON auftgtxt
  FOR EACH ROW
  EXECUTE PROCEDURE auftgtxt__b_i();

--Zahlungsplan-Status
CREATE TABLE zpstat
  (zp_status            varchar(5) PRIMARY KEY,
   zp_bez               varchar(30)
  );
-- Zahlungsplan im Verkaufsdokument
CREATE TABLE auftgdokzahlplan_predefines
 (azp_id               serial PRIMARY KEY,
  azp_name             varchar(25),
  azp_nr               integer NOT NULL,
  azp_proz             numeric(5,2), --Prozent der Zahlung, 10% z.b.
  azp_bez              text,   --Zahlungsplan Bezeichnung
  azp_bemtxt           text, --Freier Bemerkungstext zum Zahlungsplan
  azp_status           varchar(5) REFERENCES zpstat ON UPDATE CASCADE
 );--Achtung umwandeln Angebot->Auftrag beachten (auftragsverwaltung) beim anhängen neuer Spalten

--
CREATE TABLE auftgdokutxt
  (atd_dokunr            integer PRIMARY KEY,
   atd_defini            boolean NOT NULL DEFAULT FALSE,
   atd_titel             varchar(200),
   atd_datum             date DEFAULT current_date,
   atd_txt               text,
   atd_txt_rtf           text,
   atd_txt1              text,
   atd_txt1_rtf          text,
   atd_apkrzl            varchar(10),
   atd_versandort        varchar(30) REFERENCES adressen_keys ON UPDATE CASCADE,
   atd_ap                varchar(100),   --Freies Textfeld, Ansprechpartner Kunde
   atd_fixwert           numeric(16,4),
   atd_gesrab            numeric(5,2) NOT NULL DEFAULT 0,
   atd_zak               integer,
   atd_skv               integer,
   atd_sks               numeric(5,2),
   atd_v_id              integer REFERENCES versart ON UPDATE CASCADE, -- Versandart Ident
   atd_versandbem        text,
   atd_versandbem_rtf    text,
   atd_vers              varchar(75),
   atd_ld_auftg          varchar(30),  -- TransportauftragsNr
   atd_bindefrist        varchar(75),
   atd_allg1             varchar(100),--Lieferzeitraum
   atd_allg2             varchar(100), --Freies Textfeld, Ansprechpartner intern, Fachberater
   atd_zakbem            varchar(40), --Zahlungskond. Bemerkung
   atd_apint             varchar(10), --DEFAULT current_user -- CONSTRAINT in LLV Ansprechpartner Intern...Standard Kontakt aus Position 1, angemeldeter Nutzer => auftg__a_iu
   atd_apint2            varchar(50),
   atd_nachdat            date,           --Datum des Nachtrags
   atd_nachtitel         varchar(200),  --Belegtitel Nachtrag
   atd_nachtxt            text,           --Anschreiben Nachtrag
   atd_nachtxt_rtf        text,
   atd_nachtxt1           text,           --Schlusstext Nachtrag
   atd_nachtxt1_rtf       text,
   atd_empdat            date,           --Datum der Empfangsbestätigung
   atd_emptitel           varchar(200),  --Belegtitel Empfangsbestätigung
   atd_emptxt            text,           --Anschreiben Empfangsbestätigung
   atd_emptxt_rtf        text,
   atd_emptxt1           text,           --Schlusstext Empfangsbestätigung
   atd_emptxt1_rtf       text,

   -- Referenz auf Dokument des Angebots, wird über die Oberfläche gesetzt
   atd_ang_ag_dokunr    integer REFERENCES auftgdokutxt
   /*,
   -- System (tables__generate_missing_fields)
   dbrid                 VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq'),
   insert_date           DATE,
   insert_by             VARCHAR(32),
   modified_by           VARCHAR(32),
   modified_date         TIMESTAMP(0)
   */
  );--Achtung umwandeln Angebot->Auftrag beachten (auftragsverwaltung) beim anhängen neuer Spalten
  --
    -- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
    CREATE TRIGGER auftgdokutxt_set_modified
      BEFORE INSERT OR UPDATE
      ON auftgdokutxt
      FOR EACH ROW
      EXECUTE PROCEDURE table_modified();
    --

    -- Setzt eine Bindefrist aus Vorgabewert #7879
    CREATE OR REPLACE FUNCTION auftgdokutxt__b_20_i() RETURNS TRIGGER AS $$
      BEGIN
        IF EXISTS(SELECT true FROM auftg WHERE ag_dokunr = new.atd_dokunr AND ag_astat = 'A') THEN
            new.atd_bindefrist := TSystem.Settings__Get( 'angebot_vorgabewert_bindefrist' );
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftgdokutxt__b_20_i
        BEFORE INSERT
        ON auftgdokutxt
        FOR EACH ROW
        EXECUTE PROCEDURE auftgdokutxt__b_20_i();
    --

    -- standard Dokumententexte aus Vertrag oder Bemerkungsverwaltung
    -- Vorgaben: Zahlungskonditionen, Versandart
    CREATE OR REPLACE FUNCTION auftgdokutxt__b_30_i() RETURNS TRIGGER AS $$
      DECLARE
          codstat       varchar;
          krz           varchar;
          vertragtxtrec record;
          zak           integer;
          skv           integer;
          sks           numeric;
          vers          varchar;
      BEGIN
        -- standard Vertragskopftexte
        IF EXISTS(SELECT true FROM auftg WHERE ag_dokunr = new.atd_dokunr AND ag_vtp_id IS NOT NULL) THEN

            SELECT DISTINCT
              coalesce(vtr_bez, vtr_gegenstand) AS vtr_bez,
              vtr_dokutxt_anf,
              vtr_dokutxt_anf_rtf,
              vtr_dokutxt_end,
              vtr_dokutxt_end_rtf
            FROM auftg
              JOIN vertrag_pos ON ag_vtp_id = vtp_id
              JOIN vertrag ON vtp_vtr_nr = vtr_nr
            WHERE ag_dokunr = new.atd_dokunr
            INTO vertragtxtrec;

            new.atd_titel     := vertragtxtrec.vtr_bez;
            new.atd_txt       := vertragtxtrec.vtr_dokutxt_anf;
            new.atd_txt_rtf   := vertragtxtrec.vtr_dokutxt_anf_rtf;
            new.atd_txt1      := vertragtxtrec.vtr_dokutxt_end;
            new.atd_txt1_rtf  := vertragtxtrec.vtr_dokutxt_end_rtf;

        END IF;

        -- Vorgaben: Zahlungskonditionen, Versandart
            -- aus Adresse
            SELECT
              coalesce(new.atd_sks,   a1_sks),
              coalesce(new.atd_skv,   a1_skv),
              coalesce(new.atd_zak,   a1_zak),
              coalesce(new.atd_vers,  a1_vers)
            FROM auftg
              JOIN adressen_view ON ad_krz = ag_krzf
              JOIN adk1 ON a1_krz = adk_ad_krz
            WHERE ag_dokunr = new.atd_dokunr
            LIMIT 1
            INTO
              sks,
              skv,
              zak,
              vers
            ;

            -- Vorgaben global ermitteln, wenn vorher keine Angaben
            sks   := coalesce(sks,  (TAdk.StandardZak('V')).sks);
            skv   := coalesce(skv,  (TAdk.StandardZak('V')).skv);
            zak   := coalesce(zak,  (TAdk.StandardZak('V')).zak);
            vers  := coalesce(vers, (TAdk.StandardZak('V')).vers);

            -- Zahlungskonditionen gehören immer zusammen.
            IF (new.atd_sks IS NULL OR new.atd_skv IS NULL OR new.atd_zak IS NULL) THEN
                -- Ggf. fehlende ZK aus Vorgaben setzen.
                new.atd_sks := sks;
                new.atd_skv := skv;
                new.atd_zak := zak;
            END IF;

            -- Evtl. fehlende Versandart aus Vorgaben setzen.
            new.atd_vers := coalesce(new.atd_vers, vers);
        --

        -- Standardtexte Bemerkungsverwaltung.
            -- Achtung! Bei Angebot zu Auftrag wird das Dokument des Auftrags VOR den Auftragspositionen erzeugt.
            -- In dem Fall holen wir das Kürzel aus dem AusgangsANGEBOT
            -- Lücke: wir kennen in dem Fall den Status des neuen Auftrags nicht, der wird erstmal zu NULL und weiter unten im IFTHEN dann zu "E". "R" gibts aktuell hier nicht als Vorgabe
            IF NOT TSystem.Settings__GetBool('belarzu__DISABLE__DEFAULT__TEXT') THEN -- #19684 Für Kopie-Vorgänge den Text aus der Source verwenden, oder keinen Vorgabetext
                SELECT ifthen(new.atd_ang_ag_dokunr IS NULL, ag_astat, NULL),
                       ag_lkn
                  INTO codstat,
                       krz
                  FROM auftg
                 WHERE ag_dokunr = coalesce(new.atd_ang_ag_dokunr, new.atd_dokunr)
                 LIMIT 1
                ;

                -- #6388, Bei Übernahme von Angebot zu Auftrag Texte entfernen, wenn diese noch den Vorgabetexten für Angebote entsprechen.
                -- Diese werden im nächsten Schritt mit dem Standardtexten für Aufträge gefüllt.
                IF new.atd_txt = (SELECT txt FROM belarzu__zu_tit__gettxtrtf( 'DOKVERK_TXT_KOPF_AN', prodat_languages.adk1_spco(krz) ) ) THEN
                    new.atd_txt   := null;
                END IF;

                IF new.atd_txt1 = (SELECT txt FROM belarzu__zu_tit__gettxtrtf( 'DOKVERK_TXT_FUSS_AN', prodat_languages.adk1_spco(krz) ) ) THEN
                    new.atd_txt1  := null;
                END IF;

                -- Standardtexte für Angebot oder Auftrag holen
                IF new.atd_txt IS NULL THEN  -- Kopf
                    SELECT txt, txtrtf
                    FROM belarzu__zu_tit__gettxtrtf( 'DOKVERK_TXT_KOPF_' || ifthen(codstat = 'A', 'AN', 'AG'), prodat_languages.adk1_spco(krz) )
                    INTO new.atd_txt, new.atd_txt_rtf;
                END IF;

                IF new.atd_txt1 IS NULL THEN -- Fuß
                    SELECT txt, txtrtf
                    FROM belarzu__zu_tit__gettxtrtf( 'DOKVERK_TXT_FUSS_' || ifthen(codstat = 'A', 'AN', 'AG'), prodat_languages.adk1_spco(krz) )
                    INTO new.atd_txt1, new.atd_txt1_rtf;
                END IF;

                -- Empfangsbestätigung neu durch #20257
                IF new.atd_emptxt IS NULL AND COALESCE(codstat,'E') = 'E' THEN -- Kopf; bei Angebot>Auftrag codestat unbekannt
                    SELECT txt, txtrtf
                    FROM belarzu__zu_tit__gettxtrtf( 'DOKVERK_TXT_EMPF_KOPF' , prodat_languages.adk1_spco(krz) )
                    INTO new.atd_emptxt, new.atd_emptxt_rtf;
                END IF;

                IF new.atd_emptxt1 IS NULL AND COALESCE(codstat,'E') = 'E' THEN  -- Fuß
                    SELECT txt, txtrtf
                    FROM belarzu__zu_tit__gettxtrtf( 'DOKVERK_TXT_EMPF_FUSS' , prodat_languages.adk1_spco(krz) )
                    INTO new.atd_emptxt1, new.atd_emptxt1_rtf;
                END IF;

            END IF;
        --

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftgdokutxt__b_30_i
        BEFORE INSERT
        ON auftgdokutxt
        FOR EACH ROW
        EXECUTE PROCEDURE auftgdokutxt__b_30_i();
    --

    -- Gefahrenübergangsort Incoterms setzen, in der Oberfläche als Versandort bezeichnet #7990, #12892, #15002
    CREATE OR REPLACE FUNCTION auftgdokutxt__b_40_i__versandort() RETURNS trigger AS $$
      DECLARE
          _krzl varchar;
          _angebot_dokunr integer;
          _angebot_versandart varchar;
      BEGIN

          -- Fall : Es wird ein Dokument aus Angebot erstellt oder ein Dokument direkt aus Auftrag manuell
          _krzl := TAdk.DokVersandOrt( 'V', new.atd_dokunr, new.atd_vers );

          -- Fall : Es wird ein Dokument über die Oberfläche Angebot zu Auftrag erstellt
          -- andere Erstellungsreihenfolge von auftgdokutxt und auftg
          IF _krzl IS NULL THEN
              -- Variable setzen um Dokument-Nr und Versandart des Angebot-Dokuments zu holen, nicht das aktuelle Dokument
              SELECT      atd_dokunr,            atd_vers
                INTO _angebot_dokunr, _angebot_versandart
                FROM auftgdokutxt
               WHERE
                     -- atd_ang_ag_dokunr wurde neu in #15002 aufgenommen
                     -- und hält Referenz zu Angebot-Dokument
                     atd_dokunr = new.atd_ang_ag_dokunr;

              _krzl := TAdk.DokVersandOrt( 'V', _angebot_dokunr, _angebot_versandart );
          END IF;

          -- Bedingungen werden in TAdk.DokVersandOrt geprüft: NULL -> Bedinungen nicht erfüllt
          IF _krzl IS NOT NULL THEN
              new.atd_versandort := _krzl;
          END IF;

          RETURN new;

      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftgdokutxt__b_40_i__versandort
        BEFORE INSERT
        ON auftgdokutxt
        FOR EACH ROW
        WHEN (
                TSystem.Settings__GetBool__cascade_save( 'chkDokVersandOrt', true ) -- default true
            AND new.atd_vers IS NOT NULL
        )
        EXECUTE PROCEDURE auftgdokutxt__b_40_i__versandort();
    --

    --
    CREATE OR REPLACE FUNCTION auftgdokutxt__a_12_iu() RETURNS TRIGGER AS $$
      DECLARE auftggessum numeric(16,4);
              abzu_global numeric(16,4);
              auftganzpos integer;
              rundabweichung numeric(8,4);
              updategesrab boolean;
      BEGIN
        -- Globale Abzuschläge ohne Dokument jetzt zuordnen!
        UPDATE TWawi.Auftg_Abzu
           SET az_global_dokunr = new.atd_dokunr
          FROM auftg, auftgtxt
         WHERE ag_dokunr = new.atd_dokunr
           AND ag_astat = at_astat AND ag_nr = at_nr
           AND az_beleg_id = at_id
           AND az_parent_id IS null
           AND az_global_dokunr IS null;
        --
        IF new.atd_fixwert = 0 THEN
            new.atd_fixwert := NULL;
        END IF;
        --
        updategesrab := False;
        IF tg_op = 'INSERT' AND coalesce(new.atd_gesrab,0)>0 THEN
           updategesrab:=True;
        END IF;
        IF tg_op = 'UPDATE' THEN
            IF NOT Equals(new.atd_gesrab, old.atd_gesrab) THEN
               updategesrab:=True;
            END IF;
        END IF;
        --
        IF updategesrab THEN
            PERFORM execution_code__disable( _flagname => 'auftg' );
            --zuerst Hauptpositionen aktualisieren, damit werden die Unterpositionen aktualisiert
            UPDATE auftg SET ag_netto = NULL, ag_ep_netto = NULL, ag_brutto = NULL, ag_netto_basis_w = NULL, ag_brutto_basis_w = NULL
             WHERE ag_dokunr = new.atd_dokunr
               AND ag_vkptotalpos;
            --
            --Postionen, die nicht zur Hauptposition gehören müssen Ihren Wert selbst an den neuen Rabattzustand anpassen, aber nur dann - wenn nicht in Totalpos enthalten, da sonst der Rabatt hier wieder nach oben gegeben würde
            UPDATE auftg SET ag_netto = NULL, ag_ep_netto = NULL, ag_brutto = NULL, ag_netto_basis_w = NULL, ag_brutto_basis_w = NULL
             WHERE ag_id IN (SELECT ag_id FROM auftg
                              WHERE ag_dokunr = new.atd_dokunr
                                AND NOT ag_vkptotalpos
                                AND auftg_get_auftgmainpos(ag_id, True) IS NULL
                            );
            --
            PERFORM execution_code__enable( _flagname => 'auftg' );
        END IF;
        --
        IF new.atd_fixwert IS NOT NULL THEN
            --VKP-Summe aller umsatzwirksamen Positionen auf dem Dokument
            SELECT sum( round(auftg_pos_wert(ag_id), 2) ), count(1)
              INTO auftggessum, auftganzpos
              FROM auftg
             WHERE ag_dokunr = new.atd_dokunr
               AND NOT ag_nstatistik;

            abzu_global := coalesce(
                              (SELECT sum(  round(coalesce(az_betrag, 0) * az_anzahl, 2) )
                                 FROM auftgtxt
                                 JOIN TWawi.Auftg_Abzu ON at_id = az_beleg_id
                                WHERE az_global_dokunr = _dokument_nummer
                                  AND az_parent_id IS null -- globaler Abzu OHNE Positionsbezug!
                                )
                              ,0
                           );

            auftggessum := auftggessum + abzu_global;

            -- Wenn es keine Positionen gibt, auf die die Fixwertverteilung angewendet werden kann
            IF auftganzpos = 0 THEN
              RETURN new;
            END IF;

            IF round(auftggessum, 2) = round(new.atd_fixwert, 2) * (1 - new.atd_gesrab / 100) THEN
                RETURN new;
            END IF;

            PERFORM disablemodified();
            PERFORM execution_code__disable( _flagname => 'auftg' );
            --jetzt anteilig den Fixwert auf die Positionen aufteilen
            IF coalesce(auftggessum,0) > 0 THEN
                UPDATE auftg
                   SET ag_vkp = new.atd_fixwert * (1 - new.atd_gesrab / 100) * ag_vkp * (1 - ag_arab / 100) / auftggessum
                 WHERE ag_dokunr = new.atd_dokunr
                   AND NOT ag_nstatistik
                   AND ag_vkp > 0;
            ELSE
                UPDATE auftg SET ag_vkp = new.atd_fixwert * (1 - new.atd_gesrab / 100) / auftganzpos
                 WHERE ag_dokunr = new.atd_dokunr
                   AND NOT ag_nstatistik;
            END IF;
            --nun rundungsprobleme in der pos 1 klären
            SELECT sum(auftg_pos_wert(ag_id)) INTO auftggessum FROM auftg WHERE ag_dokunr=new.atd_dokunr AND NOT ag_nstatistik;

            rundabweichung := new.atd_fixwert - auftggessum;
            IF rundabweichung <> 0 THEN
                --RAISE EXCEPTION '%', rundabweichung;
                UPDATE auftg SET ag_vkp = ag_vkp + rundabweichung / ag_stk
                 WHERE ag_dokunr = new.atd_dokunr
                   AND ag_pos = (SELECT min(ag_pos) FROM auftg WHERE ag_dokunr = new.atd_dokunr AND NOT ag_nstatistik AND NOT ag_vkptotalpos);
            END IF;

            PERFORM enablemodified();
            PERFORM execution_code__enable( _flagname => 'auftg' );
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftgdokutxt__a_12_iu
        AFTER INSERT OR UPDATE
        ON auftgdokutxt
        FOR EACH ROW
        EXECUTE PROCEDURE auftgdokutxt__a_12_iu();
    --

    --
    CREATE OR REPLACE FUNCTION auftgdokutxt__a_u__erstdataendern() RETURNS TRIGGER AS $$
      BEGIN
        -- Schließe Nachtragsfelder aus #4911 > hat eigenes Datum
        IF (new.atd_nachdat IS DISTINCT FROM old.atd_nachdat)
           OR
           (new.atd_nachtitel IS DISTINCT FROM old.atd_nachtitel)
           OR
           (new.atd_nachtxt IS DISTINCT FROM old.atd_nachtxt)
           OR
           (new.atd_nachtxt1 IS DISTINCT FROM old.atd_nachtxt1)
        THEN
          --änderung an Feldern Nachtrag => nicht Datum vorn umschreiben, siehe Kommentar oben
        ELSE --änderung an relevanten Feld => Abfrage ob Erstelldatum anpassen
          PERFORM PRODAT_MESSAGE_YES_NO(17696, 'Message.auftgdokutxt.erstdataendern.yes', NULL, new.atd_dokunr);
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER auftgdokutxt__a_u__erstdataendern
        AFTER UPDATE
        ON auftgdokutxt
        FOR EACH ROW
        WHEN ((new.atd_datum < current_date) AND (new.atd_datum = old.atd_datum) AND NOT TSystem.Settings__GetBool__cascade_save('auftgdokutxt__a_u__erstdataendern__disabled')/*#19289*/)
        EXECUTE PROCEDURE auftgdokutxt__a_u__erstdataendern();
      --

-- Status Zahlungsplan im Verkaufsdokument auftgdokzahlplan
CREATE TABLE auftgdokzahlplan
 (azp_atd_dokunr       INTEGER NOT NULL REFERENCES auftgdokutxt ON UPDATE CASCADE ON DELETE CASCADE,--Dok.NR zum Zahlungsplan
  azp_be_bnr           VARCHAR(15),--BelegNR zum Zahlungsplan, X Constraint
  azp_betrag           NUMERIC(12,4)  --Zahlbetrag
 ) INHERITS(auftgdokzahlplan_predefines) ;--Achtung umwandeln Angebot->Auftrag beachten (auftragsverwaltung) beim anhängen neuer Spalten

 CREATE INDEX auftgdokzahlplan_azp_status ON auftgdokzahlplan(azp_status);
 CREATE INDEX auftgdokzahlplan_azp_be_bnr ON auftgdokzahlplan(azp_be_bnr) WHERE azp_be_bnr IS NOT NULL;
 CREATE INDEX auftgdokzahlplan_azp_be_bnr_like ON auftgdokzahlplan(azp_be_bnr varchar_pattern_ops) WHERE azp_be_bnr IS NOT NULL;
--

-- auftg
CREATE TABLE auftglog (
  agl_id               SERIAL PRIMARY KEY,
  agl_ag_id            INTEGER NOT NULL REFERENCES auftg ON UPDATE CASCADE ON DELETE CASCADE,
  agl_old_ag_stk       NUMERIC(16,4),
  agl_new_ag_stk       NUMERIC(16,4),
  agl_old_ag_netto     NUMERIC(16,4),
  agl_new_ag_netto     NUMERIC(16,4),
  agl_umsatzwirksam    BOOL DEFAULT TRUE,
  agl_txt              TEXT,
  -- System (tables__generate_missing_fields)
  insert_date          DATE,
  insert_by            VARCHAR(32),
  modified_by          VARCHAR(32),
  modified_date        TIMESTAMP(0)
  );

 CREATE INDEX auftglog_insert_date ON auftglog(insert_date);

 -- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
 CREATE TRIGGER auftglog_set_modified
    BEFORE INSERT OR UPDATE
    ON auftglog
    FOR EACH ROW
    EXECUTE PROCEDURE table_modified();
--

--
CREATE TABLE auftgposlog (
  agplog_id                     SERIAL PRIMARY KEY,
  agplog_time                   TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT currenttime(), --zeitpunkt (insert und modified date haben nur datum, keine uhrzeit)
  agplog_usr                    VARCHAR(30) DEFAULT tsystem.current_user_ll_db_usename(true),
  agplog_trig                   VARCHAR(6), -- Trigger INSERT, UPDATE oder DELETE
  agplog_ag_id                  INTEGER,
  agplog_ag_nr                  VARCHAR(30), --NOT NULL,
  agplog_ag_pos_old             INTEGER, --NOT NULL,
  agplog_ag_pos_new             INTEGER,
  agplog_ag_aknr_old            VARCHAR(40), -- NOT NULL REFERENCES art ON UPDATE CASCADE,
  agplog_ag_aknr_new            VARCHAR(40),
  agplog_ag_akbz_old            VARCHAR(100),
  agplog_ag_akbz_new            VARCHAR(100),
  agplog_ag_an_nr_old           VARCHAR(50), --REFERENCES anl,
  agplog_ag_an_nr_new           VARCHAR(50),
  agplog_ag_stk_old             NUMERIC(12,4), -- NOT NULL,
  agplog_ag_stk_new             NUMERIC(12,4),
  agplog_ag_mcv_old             INTEGER,
  agplog_ag_mcv_new             INTEGER,
  agplog_ag_vkp_old             NUMERIC(20,8), --NOT NULL,
  agplog_ag_vkp_new             NUMERIC(20,8),
  agplog_ag_done_old            BOOLEAN,
  agplog_ag_done_new            BOOLEAN,
  agplog_ag_storno_old          BOOLEAN,
  agplog_ag_storno_new          BOOLEAN,
  agplog_ag_kdatum_old          DATE,
  agplog_ag_kdatum_new          DATE,
  agplog_ag_ldatum_old          DATE,
  agplog_ag_ldatum_new          DATE,
  -- nachfolgende für auftgmatinfo__a_u_log
  agplog_agmi_v_id_old          INTEGER, --REFERENCES versart
  agplog_agmi_v_id_new          INTEGER,
  agplog_agmi_dat_old           DATE,
  agplog_agmi_dat_new           DATE,
  agplog_agmi_beistell_old      BOOLEAN,
  agplog_agmi_beistell_new      BOOLEAN,
  agplog_agmi_ld_auftg_old      VARCHAR(30),
  agplog_agmi_ld_auftg_new      VARCHAR(30),
  agplog_agmi_sernr_old         TEXT,
  agplog_agmi_sernr_new         TEXT,
  agplog_agmi_allg1_old         VARCHAR(50),
  agplog_agmi_allg1_new         VARCHAR(50),
  --
  agplog_is_in_auditlog         BOOLEAN DEFAULT true    -- Dieser Datensatz ist aufgrund des Parallelbetriebs der Logs ebenso im Audit-Log
  -- System (tables__generate_missing_fields)
  --   kein automatisches dbrid, insert_date, insert_by, modified_by, modified_date und table_delete-Trigger (tables__fieldInfo__fetch)
  );


 CREATE INDEX auftgposlog_ag_id ON auftgposlog(agplog_ag_id);

 -- INSERT: nur Ergänzungen von Materialpositionen (Status I) loggen, diesbzgl. kein Log für Status E
 CREATE OR REPLACE FUNCTION auftg__a_iud_log() RETURNS TRIGGER AS $$
  DECLARE     ag_pos_old         INTEGER;
              ag_pos_new         INTEGER;
              ag_aknr_old        VARCHAR;
              ag_aknr_new        VARCHAR;
              ag_akbz_old        VARCHAR;
              ag_akbz_new        VARCHAR;
              ag_an_nr_old       VARCHAR;
              ag_an_nr_new       VARCHAR;
              ag_stk_old         NUMERIC;
              ag_stk_new         NUMERIC;
              ag_mcv_old         INTEGER;
              ag_mcv_new         INTEGER;
              ag_vkp_old         NUMERIC;
              ag_vkp_new         NUMERIC;
              ag_done_old        BOOLEAN;
              ag_done_new        BOOLEAN;
              ag_storno_old      BOOLEAN;
              ag_storno_new      BOOLEAN;
              ag_kdatum_old      DATE;
              ag_kdatum_new      DATE;
              ag_ldatum_old      DATE;
              ag_ldatum_new      DATE;
              doit               BOOL;
  BEGIN
    IF tg_op='INSERT' THEN
        IF (new.ag_astat = 'I' AND new.ag_parentabk IS NOT NULL AND COALESCE(new.ag_bda, '') = 'ADD' ) THEN -- Materialposition wird ergänzt
            INSERT INTO auftgposlog (agplog_trig, agplog_ag_id, agplog_ag_nr, agplog_ag_pos_new, agplog_ag_aknr_new,
                agplog_ag_akbz_new, agplog_ag_an_nr_new, agplog_ag_stk_new, agplog_ag_vkp_new, agplog_ag_done_new, agplog_ag_storno_new,
                agplog_ag_kdatum_new, agplog_ag_ldatum_new, agplog_ag_mcv_new)
            VALUES ('INSERT', new.ag_id, new.ag_nr, new.ag_pos, new.ag_aknr,
                new.ag_akbz, new.ag_an_nr, new.ag_stk, new.ag_vkp, new.ag_done, new.ag_storno,
                new.ag_kdatum, new.ag_ldatum, new.ag_mcv);
        END IF;
    END IF;

    IF tg_op='UPDATE' THEN
        doit:=FALSE;
        -- ag_pos loggen wir immer mit, wenn sich etwas ändert. Damit bleibt Zuordnung erhalten, auch wenn Satz später gelöscht wird.
        ag_pos_old:=old.ag_pos;
        ag_pos_new:=new.ag_pos;
        IF new.ag_pos IS DISTINCT FROM old.ag_pos THEN
            doit:=TRUE;
        END IF;
        --
        IF new.ag_aknr IS DISTINCT FROM old.ag_aknr THEN
            doit:=TRUE;
            ag_aknr_old:=old.ag_aknr;
            ag_aknr_new:=new.ag_aknr;
        END IF;
        --
        IF new.ag_akbz IS DISTINCT FROM old.ag_akbz THEN
            doit:=TRUE;
            ag_akbz_old:=old.ag_akbz;
            ag_akbz_new:=new.ag_akbz;
        END IF;
        --
        IF new.ag_an_nr IS DISTINCT FROM old.ag_an_nr THEN
            doit:=TRUE;
            ag_an_nr_old:=old.ag_an_nr;
            ag_an_nr_new:=new.ag_an_nr;
        END IF;
        --
        IF new.ag_stk IS DISTINCT FROM old.ag_stk THEN
            doit:=TRUE;
            ag_stk_old:=old.ag_stk;
            ag_stk_new:=new.ag_stk;
        END IF;
        --
        IF new.ag_vkp IS DISTINCT FROM old.ag_vkp THEN
            doit:=TRUE;
            ag_vkp_old:=old.ag_vkp;
            ag_vkp_new:=new.ag_vkp;
        END IF;
        --
        IF new.ag_done IS DISTINCT FROM old.ag_done THEN
            doit:=TRUE;
            ag_done_old:=old.ag_done;
            ag_done_new:=new.ag_done;
        END IF;
        --
        IF new.ag_storno IS DISTINCT FROM old.ag_storno THEN
            doit:=TRUE;
            ag_storno_old:=old.ag_storno;
            ag_storno_new:=new.ag_storno;
        END IF;
        --
        IF new.ag_kdatum IS DISTINCT FROM old.ag_kdatum THEN
            doit:=TRUE;
            ag_kdatum_old:=old.ag_kdatum;
            ag_kdatum_new:=new.ag_kdatum;
        END IF;
        --
        IF new.ag_ldatum IS DISTINCT FROM old.ag_ldatum THEN
            doit:=TRUE;
            ag_ldatum_old:=old.ag_ldatum;
            ag_ldatum_new:=new.ag_ldatum;
        END IF;
        --
        IF new.ag_mcv IS DISTINCT FROM old.ag_mcv THEN
            doit:=TRUE;
            ag_mcv_old:=old.ag_mcv;
            ag_mcv_new:=new.ag_mcv;
        END IF;
        --
        --falls Änderung, dann eintragen in Log-Tabelle
        IF doit THEN
            INSERT INTO auftgposlog (agplog_trig, agplog_ag_id, agplog_ag_nr, agplog_ag_pos_old, agplog_ag_pos_new,
                agplog_ag_aknr_old, agplog_ag_aknr_new, agplog_ag_akbz_old, agplog_ag_akbz_new,
                agplog_ag_an_nr_old, agplog_ag_an_nr_new, agplog_ag_stk_old, agplog_ag_stk_new,
                agplog_ag_vkp_old, agplog_ag_vkp_new, agplog_ag_done_old, agplog_ag_done_new,
                agplog_ag_storno_old, agplog_ag_storno_new, agplog_ag_kdatum_old, agplog_ag_kdatum_new,
                agplog_ag_ldatum_old, agplog_ag_ldatum_new, agplog_ag_mcv_old, agplog_ag_mcv_new)
            VALUES ('UPDATE', new.ag_id, new.ag_nr, ag_pos_old, ag_pos_new,
                ag_aknr_old, ag_aknr_new, ag_akbz_old, ag_akbz_new,
                ag_an_nr_old, ag_an_nr_new, ag_stk_old, ag_stk_new,
                ag_vkp_old, ag_vkp_new, ag_done_old, ag_done_new,
                ag_storno_old, ag_storno_new, ag_kdatum_old, ag_kdatum_new,
                ag_ldatum_old, ag_ldatum_new, ag_mcv_old, ag_mcv_new);
        END IF;
    END IF;

    IF tg_op='DELETE' THEN
        INSERT INTO auftgposlog (agplog_trig, agplog_ag_id, agplog_ag_nr, agplog_ag_pos_old, agplog_ag_aknr_old,
            agplog_ag_akbz_old, agplog_ag_an_nr_old, agplog_ag_stk_old, agplog_ag_vkp_old, agplog_ag_done_old, agplog_ag_storno_old,
            agplog_ag_kdatum_old, agplog_ag_ldatum_old, agplog_ag_mcv_old)
        VALUES ('DELETE', old.ag_id, old.ag_nr, old.ag_pos, old.ag_aknr,
            old.ag_akbz, old.ag_an_nr, old.ag_stk, old.ag_vkp, old.ag_done, old.ag_storno,
            old.ag_kdatum, old.ag_ldatum, old.ag_mcv);
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  --
  CREATE TRIGGER auftg__a_iud_log
    AFTER INSERT OR UPDATE OR DELETE
    ON auftg
    FOR EACH ROW
    EXECUTE PROCEDURE auftg__a_iud_log();
  --

-- Ab- und Zuschlaege zu einer Auftragsposition
 CREATE TABLE auftgabzu (                                                   -- VIEWFELDER
   az_id            SERIAL PRIMARY KEY,                                       --  ID des Zuschlags
   az_type          VARCHAR(1) NOT NULL DEFAULT 'E',                          --  Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
   az_pos           INTEGER,                                                  --  Position
   az_abz_id        INTEGER NOT NULL REFERENCES abzu,                         --  ID der Vorgabe
   az_at_id         INTEGER NOT NULL REFERENCES auftgtxt ON DELETE CASCADE,   -- -- KopfID für PositionsUNGEBUNDENE Globale Zuschläge #17838
   az_ag_id         INTEGER          REFERENCES auftg    ON DELETE CASCADE,   --  ID des Datensatzes an dem der Zuschlag hängt
   az_global_ag_dokunr  integer      REFERENCES auftgdokutxt ON DELETE SET null, -- globaler Abzuschlag OHNE Positionszuordnung!
   az_anz           NUMERIC(12,4) NOT NULL DEFAULT 1,                               --  Anzahl / Menge
   az_abzubetrag    NUMERIC(12,4) NOT NULL DEFAULT 0,                               --  Betrag in Währung des Parent-Datensatzes
   az_abzuproz      NUMERIC(12,4),                                            --  Prozentualer Zuschlag auf Basis des Parent-Betrags
   az_canSkonto     BOOLEAN NOT NULL DEFAULT TRUE,                            --  Gilt Skonto für den Zuschlag?
   az_steucode      INTEGER REFERENCES steutxt,                               --  Steuercode (meist gleich Parent)
   az_steuproz      NUMERIC(5,2) NOT NULL DEFAULT 0,                          --  Prozentsatz der Steuer
   az_konto         VARCHAR(25),                                              --  Kontierung
   az_visible       BOOLEAN NOT NULL DEFAULT TRUE,                            --  Auf Dokument sichtbar oder nicht?
   az_zutxt         TEXT,                                                     --  Zusätzlicher Hinweistext
   az_zutxt_rtf     TEXT,                                                     --  Zusätzlicher Hinweistext (RTF)
   az_zutxt_int     TEXT,                                                     --  Interner zusatztext (erscheint nicht auf Dokumenten)
   az_source_table  VARCHAR(40),                                              --  Aus welcher Quelle wurde Abzu hierhin kopiert
   az_source_dbrid  VARCHAR(32),                                              --  Aus welchem Datensatz wurde Abzu hierhin kopiert
   --                                                                       -- ZUSATZFELDER
   az_done          BOOLEAN NOT NULL DEFAULT FALSE,                           -- Gesamte Zuschlag wurde in eine Rechnung weitergegeben
   az_bebnr         VARCHAR(15),                                              -- REFERENCES belkopf ON UPDATE CASCADE   das geht nicht belkopf ist ja noch nicht angelegt
   CHECK (az_abzuproz <> 0)      -- auftgabzu_az_abzuproz_check
  );

 CREATE INDEX auftgabzu_ag_id ON auftgabzu(az_ag_id);
 CREATE INDEX auftgabzu_at_id ON auftgabzu(az_at_id);
 CREATE INDEX auftgabzu_ag_dokunr ON auftgabzu(az_global_ag_dokunr) WHERE az_global_ag_dokunr IS NOT null;
--

-- Quell-Zuschläge mit Typ 'E' werden erledigt gesetzt bei Übernahme aus Rahmen oder Angebot
 -- DROP FUNCTION IF EXISTS auftgabzu__a10_iud_srcabzu_done() CASCADE;
CREATE OR REPLACE FUNCTION auftgabzu__a10_iud_srcabzu_done() RETURNS TRIGGER AS $$
 BEGIN

  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    IF (new.az_source_table='auftgabzu') AND (new.az_type = 'E')  THEN
      PERFORM TWawi.Abzu_Set_Done(new.az_source_table, new.az_source_dbrid, TRUE, TRUE);
    END IF;
  ELSE
    IF (old.az_source_table='auftgabzu') AND (old.az_type = 'E')THEN
      -- TODO: Raise Notice beim wieder öffnen
      PERFORM TWawi.Abzu_Set_Done(old.az_source_table, old.az_source_dbrid, FALSE, TRUE);
   END IF;
  END IF;

  RETURN new;
 END $$ LANGUAGE plpgsql;
--
CREATE TRIGGER auftgabzu__a10_iud_srcabzu_done
 AFTER INSERT OR UPDATE OR DELETE
 ON auftgabzu
 FOR EACH ROW
 EXECUTE PROCEDURE auftgabzu__a10_iud_srcabzu_done();
--

CREATE OR REPLACE FUNCTION auftgabzu__a_iud() RETURNS TRIGGER AS $$
 DECLARE _auftgabzu RECORD;
         I INTEGER;
         agid INTEGER;
 BEGIN
 /*----------------BEACHTEN-------------------------------------------------------------------------------------------------------------------------------
   Wenn Auftg-Updates entfallen sollten, "UPDATE auftg SET ag_netto = 0 WHERE ag_id = new/old.az_ag_id" ausführen, damit Positionssumme aktualisiert wird.
   -------------------------------------------------------------------------------------------------------------------------------------------------------*/
  IF tg_op='DELETE' THEN
        agid:=old.az_ag_id;
  ELSE
        agid:=new.az_ag_id;
  END IF;
  --
  PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', agid);
  --
  -- Aktualisierung Positionssummen
  IF TG_OP = 'UPDATE' THEN
        UPDATE auftg SET ag_netto=0 WHERE ag_id = agid AND NOT (new.az_abzubetrag <> old.az_abzubetrag AND new.az_abzuproz IS NOT NULL);
        -- Bei Änderung des Betrag von außen (siehe auftg__b_iu__possum), wenn prozentualer Abzu, dann KEINE Aktualiserung der ldsdok starten.
        -- Wenn Prozentsatz des Abzu geändert wird, findet Berechnung des Betrags hiermit in auftg__b_iu__possum statt - läuft wieder hier hinein (UPDATE) und ignoriert Kreisaufruf durch Bedingung.
  ELSE -- INSERT, DELETE
        UPDATE auftg SET ag_netto=0 WHERE ag_id = agid;
  END IF;

  --Meldung ausgeben,wennn Steuersatz ungültig
  IF NOT (tg_op = 'DELETE') THEN
        IF EXISTS(SELECT true FROM steutxt WHERE steu_z=new.az_steucode AND steu_valid_to<current_date) THEN
                PERFORM PRODAT_TEXT(15810);  --Leider keine Verknüpfung über steucode möglich <==== (LG) Uhm ... Wieso?!?
        END IF;
  END IF;

  --
  IF tg_op='DELETE' THEN
        RETURN old;
  ELSE
        RETURN new;
  END IF;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER auftgabzu__a_iud
   AFTER INSERT OR UPDATE OR DELETE
   ON auftgabzu
   FOR EACH ROW
   EXECUTE PROCEDURE auftgabzu__a_iud();
  ---
--- #17838
CREATE OR REPLACE FUNCTION auftgabzu__b_iu__az_ag_id() RETURNS TRIGGER AS $$
  BEGIN
     new.az_at_id := at_id FROM auftg JOIN auftgtxt ON at_astat = ag_astat AND at_nr = ag_nr WHERE ag_id = new.az_ag_id;
     RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER auftgabzu__b_iu__az_ag_id
    BEFORE INSERT OR UPDATE
    OF az_ag_id
    ON auftgabzu
    FOR EACH ROW
    WHEN (new.az_ag_id IS NOT null)
    EXECUTE PROCEDURE auftgabzu__b_iu__az_ag_id();
---

--Kundenzuordnung aus Auftg/Artikelstamm
CREATE TABLE artzuo (
  az_id             SERIAL PRIMARY KEY,
  az_pronr          VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE,
  az_prokrz         VARCHAR(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,
  az_kunr           VARCHAR(50), -- Artikelnummer Kunde
  az_kunr_referenz  VARCHAR(50), -- Artikelnummer Kunde Referenz
  az_bez            VARCHAR(100),
  az_minmenge       NUMERIC,        -- Mindestmenge Rahmenauftrag #5381#note-25
  az_minmengeproz   NUMERIC,        -- Mindestmenge Prozentual Rahmenauftrag #5381#note-25
  az_bem            TEXT,
  az_liefbem        TEXT,
  az_kupr           NUMERIC, --Kundenpreis
  az_waco           VARCHAR(3) NOT NULL REFERENCES bewa,
  az_gdatum         DATE DEFAULT current_date,
  az_bisdatum       DATE,
  az_nident         VARCHAR(50) REFERENCES qsnorm ON UPDATE CASCADE -- Kunde verlangt Norm für diesen Artikel
  );

  -- Indizes
    CREATE INDEX artzuo_az_pronr_az_prokrz ON artzuo(az_pronr, az_prokrz);
  --

  CREATE TRIGGER artzuo__a_d
   AFTER DELETE
   ON artzuo
   FOR EACH ROW
   EXECUTE PROCEDURE table_delete();
 --

 -- Referenz für Angebote/Aufträge nachtragen, die offen sind und noch kein Dokument haben. #6041
 -- Änderung der Referenz im Artikelstamm soll auch in offene Aufträge zurückschreiben
 CREATE OR REPLACE FUNCTION artzuo__a_iu_kunr() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE auftg SET
      ag_aknr_referenz = new.az_kunr
    WHERE ag_astat <> 'I' AND ag_aknr = new.az_pronr AND ag_lkn = new.az_prokrz
      AND NOT ag_done AND ag_dokunr IS NULL;
      --AND COALESCE(ag_aknr_referenz, '') = ''; // Entfernt so dass auch bei Anpassungen der Artikelnummer die offenen
      --Aufträge angepasst werden können
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER artzuo__a_iu_kunr
    AFTER INSERT OR UPDATE
    OF az_pronr, az_prokrz, az_kunr
    ON artzuo
    FOR EACH ROW
    WHEN (COALESCE(new.az_kunr, '') <> '')
    EXECUTE PROCEDURE artzuo__a_iu_kunr();
 --

 -- Ablaufdatum im Vordatensatz setzen, wenn ein neuer Preis kommt.
 CREATE OR REPLACE FUNCTION artzuo__a_iu_datum() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE artzuo SET
      az_bisdatum = new.az_gdatum-1
    WHERE az_pronr = new.az_pronr AND az_prokrz = new.az_prokrz AND az_id <> new.az_id
      AND COALESCE(az_kunr, '') = COALESCE(new.az_kunr , '')
      AND az_bisdatum IS NULL AND az_gdatum < new.az_gdatum;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER artzuo__a_iu_datum
    AFTER INSERT OR UPDATE
    OF az_pronr, az_prokrz, az_kunr, az_gdatum, az_bisdatum -- rekursiv durch UPDATE OF az_bisdatum
    ON artzuo
    FOR EACH ROW
    EXECUTE PROCEDURE artzuo__a_iu_datum();
 --

 CREATE OR REPLACE FUNCTION artzuo__a_iud_keywordsearch() RETURNS TRIGGER AS $$
  DECLARE krz VARCHAR;
  BEGIN
   IF tg_op='DELETE' THEN
      krz:=old.az_pronr;
   ELSE
      krz:=new.az_pronr;
   END IF;
   PERFORM TSystem.kws_create_keywords(art) FROM art WHERE ak_nr=krz;
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER artzuo__a_iud_keywordsearch
   AFTER INSERT OR UPDATE OR DELETE
   ON artzuo
   FOR EACH ROW
   EXECUTE PROCEDURE artzuo__a_iud_keywordsearch();
  ---
-- Währung vom Debitor übernehmen. siehe Ticket 17473
  CREATE OR REPLACE FUNCTION artzuo__b_i_waco() RETURNS TRIGGER AS $$
    BEGIN
      -- Wenn vorhanden, die Währung des Debitor-Datensatzes setzen, ansonsten auf die Standardwährung zurückfallen.
      new.az_waco := adk1__a1_waco__or__basis_w__by__a1_krz__get( new.az_prokrz );
      RETURN new;
    END $$ LANGUAGE plpgsql;
  ---
  CREATE TRIGGER artzuo__b_i_waco
    BEFORE INSERT
      ON artzuo
    FOR EACH ROW
      WHEN ( new.az_waco IS NULL )
    EXECUTE PROCEDURE artzuo__b_i_waco();

----Preis/Positionen aus Vorkalkulation für Angebots/Auftragspreis---------------
CREATE TABLE auftgvorkalk
 (avk_id        SERIAL PRIMARY KEY,
  avk_agid      INTEGER REFERENCES auftg ON UPDATE CASCADE ON DELETE CASCADE,
  avk_pos       INTEGER NOT NULL,       --Position
  avk_anz       NUMERIC,                --Anzahl
  avk_me        VARCHAR(20),            --Mengeneinheit für Menge, zB Stunde, Stück, kg etc
  avk_preis     NUMERIC,                --Positionspreis
  avk_bez       VARCHAR(40),            --Bezeichnung
  avk_indok     BOOL NOT NULL DEFAULT FALSE, --soll auf Dokument dargestellt werden
  avk_txt       TEXT,                   --Beschreibungstext/Erläuterung
  avk_txt_rtf   TEXT
 );

----Staffelpreise für Angebotserstellung im Auftrag (aus Artikelstamm geholt bei Angebotsanlage)
CREATE TABLE auftgstp
 (auftgstp_id           SERIAL NOT NULL PRIMARY KEY,
  auftgstp_agid         INTEGER NOT NULL REFERENCES auftg ON DELETE CASCADE,
  auftgstp_aknr         VARCHAR(40) NOT NULL REFERENCES art ON DELETE CASCADE ON UPDATE CASCADE,
  auftgstp_txt          TEXT,
  auftgstp_txt_rtf      TEXT,           -- #6965 Verkauf, Staffelpreise - Formatierung für Zusatztext
  auftgstp_menge        NUMERIC(12,4) NOT NULL,
  auftgstp_vkp          NUMERIC(12,4) NOT NULL
  --,auftgstp_fixpreis  BOOL NOT NULL DEFAULT FALSE
 );

CREATE INDEX auftgstp_agid ON auftgstp(auftgstp_agid);

--Materialliste Projekt -> Versandinformationen usw (wie kommt das Material zur Baustelle, ist das Material bereits Bedarfsverursachend usw)
CREATE TABLE auftgmatinfo (
  agmi_id               SERIAL PRIMARY KEY,
  agmi_ag_id            INTEGER UNIQUE NOT NULL REFERENCES auftg ON UPDATE CASCADE ON DELETE CASCADE,
  agmi_v_id             INTEGER REFERENCES versart ON UPDATE CASCADE,
  agmi_wait             BOOL DEFAULT FALSE NOT NULL,
  agmi_stat             VARCHAR(5) REFERENCES anlstat,--
  agmi_ekenner_krz      VARCHAR(20), -- Ersatzteilkenner analog st_ekenner_krz, o6_ekenner_krz
  agmi_vtermweek        VARCHAR(7),--versand des Materials in KW X
  agmi_dat              DATE,
  agmi_beistell         BOOL NOT NULL DEFAULT FALSE,--Beistellmaterial (nicht bedarfsauslösend; nicht bedarfsdeckend)
  agmi_ld_auftg         VARCHAR(30),--Transport Auftrag Nr, kein direktlink zu Einkauf da auch häufig im Internet ausgelöst, nur die Nummer übernehmen
  agmi_lg_ort           VARCHAR(75),
  agmi_lg_chnr          VARCHAR(50), -- Charge #7537
  agmi_sernr            TEXT,
  agmi_txt              TEXT,
  agmi_allg1            VARCHAR(50)
  );

 CREATE OR REPLACE FUNCTION auftgmatinfo__b_00_i() RETURNS TRIGGER AS $$
    BEGIN
        IF    new.agmi_beistell IS true
           OR coalesce(new.agmi_dat::varchar, new.agmi_vtermweek) IS NOT null
        THEN
           -- Der gesamte Algorithmus geht davon aus, das hier ein Leerdatensatz erstellt wird (auftg__a_10_i > INSERT INTO auftgmatinfo(agmi_ag_id, agmi_beistell) VALUES (new.ag_id, COALESCE(beistell, false));)#
           -- Falls hier Beistellung gesetzt wäre, oder ein Datum müßte auch die Bedarfsberechnung neu angestoßen werden. > auftgmatinfo__a_u__dat__beistell
           -- Da ja bis hier die auftg die Bedarfsberechnung angestossen hat
           RAISE EXCEPTION 'it is not allowed to INSERT INTO auftgmatinfo COLUMNS agmi_beistell, agmi_dat, agmi_vtermweek WITH VALUES';
        END IF;

        RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER auftgmatinfo__b_00_i
    BEFORE INSERT
    ON auftgmatinfo
    FOR EACH ROW
    EXECUTE PROCEDURE auftgmatinfo__b_00_i();

 --
 CREATE OR REPLACE FUNCTION auftgmatinfo__b_u__dat__v_id() RETURNS TRIGGER AS $$
  BEGIN
    IF new.agmi_dat IS NOT NULL THEN
       new.agmi_vtermweek := termweek(new.agmi_dat);
    END IF;

    IF new.agmi_v_id  = 0 THEN
       new.agmi_v_id := NULL;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER auftgmatinfo__b_u__dat__v_id
    BEFORE UPDATE
    OF agmi_dat, agmi_vtermweek, agmi_v_id
    ON auftgmatinfo
    FOR EACH ROW
    EXECUTE PROCEDURE auftgmatinfo__b_u__dat__v_id();
 --

--
CREATE OR REPLACE FUNCTION auftgmatinfo__a_u__dat__beistell() RETURNS TRIGGER AS $$
  BEGIN
    PERFORM disablemodified();
    PERFORM execution_code__disable( _flagname => 'auftg' );

    -- Materiallisten-Datum übersteuern auftg-datum und überschreiben diese
    PERFORM tabk.abk__auftgi_kldatum__refresh(ARRAY[new.agmi_ag_id]);

    IF new.agmi_beistell IS DISTINCT FROM old.agmi_beistell THEN
        UPDATE auftg
           SET ag_nbedarf = new.agmi_beistell
         WHERE ag_id = new.agmi_ag_id
           AND ag_nbedarf IS DISTINCT FROM new.agmi_beistell;
    END IF;

    -- Bestandsabgleich, falls z.B. Status "Beistellmaterial" umgeswitched wird. (ACHTUNG: agmi_beistell = Beistellung durch Kunde vs status 'BL' > Beistellung an Lieferant ??????)
    -- nur after Update, sonst doppelt da bereits durch auftg!
    PERFORM tartikel.prepare_artikel_bedarf(ag_aknr, true) FROM auftg WHERE ag_id = new.agmi_ag_id;
    PERFORM do_artikel_bedarf();

    PERFORM enablemodified();
    PERFORM execution_code__enable( _flagname => 'auftg' );

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER auftgmatinfo__a_u__dat__beistell
    AFTER UPDATE
    OF agmi_dat, agmi_vtermweek, agmi_beistell
    ON auftgmatinfo
    FOR EACH ROW
    EXECUTE PROCEDURE auftgmatinfo__a_u__dat__beistell();
--

 -- Logging der Auftragsposition-Zusatzinformationen
 -- schreibt in auftgposlog
 CREATE OR REPLACE FUNCTION auftgmatinfo__a_u_log() RETURNS TRIGGER AS $$
  DECLARE agmi_v_id_old         INTEGER;
          agmi_v_id_new         INTEGER;
          agmi_dat_old          DATE;
          agmi_dat_new          DATE;
          agmi_beistell_old     BOOLEAN;
          agmi_beistell_new     BOOLEAN;
          agmi_ld_auftg_old     VARCHAR;
          agmi_ld_auftg_new     VARCHAR;
          agmi_sernr_old        TEXT;
          agmi_sernr_new        TEXT;
          agmi_allg1_old        VARCHAR;
          agmi_allg1_new        VARCHAR;
          auftg_r               RECORD;
          doit                  BOOLEAN;
  BEGIN
    doit:=FALSE;
    IF tg_op='UPDATE' THEN
        IF new.agmi_v_id IS DISTINCT FROM old.agmi_v_id THEN
            doit:=TRUE;
            agmi_v_id_old:=old.agmi_v_id;
            agmi_v_id_new:=new.agmi_v_id;
        END IF;
        --
        IF new.agmi_dat IS DISTINCT FROM old.agmi_dat THEN
            doit:=TRUE;
            agmi_dat_old:=old.agmi_dat;
            agmi_dat_new:=new.agmi_dat;
        END IF;
        --
        IF new.agmi_beistell IS DISTINCT FROM old.agmi_beistell THEN
            doit:=TRUE;
            agmi_beistell_old:=old.agmi_beistell;
            agmi_beistell_new:=new.agmi_beistell;
        END IF;
        --
        IF new.agmi_ld_auftg IS DISTINCT FROM old.agmi_ld_auftg THEN
            doit:=TRUE;
            agmi_ld_auftg_old:=old.agmi_ld_auftg;
            agmi_ld_auftg_new:=new.agmi_ld_auftg;
        END IF;
        --
        IF new.agmi_sernr IS DISTINCT FROM old.agmi_sernr THEN
            doit:=TRUE;
            agmi_sernr_old:=old.agmi_sernr;
            agmi_sernr_new:=new.agmi_sernr;
        END IF;
        --
        IF new.agmi_allg1 IS DISTINCT FROM old.agmi_allg1 THEN
            doit:=TRUE;
            agmi_allg1_old:=old.agmi_allg1;
            agmi_allg1_new:=new.agmi_allg1;
        END IF;
        --falls Änderung, dann eintragen in Log-Tabelle
        IF doit THEN
            SELECT * FROM auftg INTO auftg_r WHERE ag_id=new.agmi_ag_id;
            INSERT INTO auftgposlog (agplog_trig, agplog_ag_id, agplog_ag_nr, agplog_ag_pos_old, agplog_ag_pos_new,
                agplog_agmi_v_id_old, agplog_agmi_v_id_new, agplog_agmi_dat_old, agplog_agmi_dat_new, agplog_agmi_beistell_old, agplog_agmi_beistell_new,
                agplog_agmi_ld_auftg_old, agplog_agmi_ld_auftg_new, agplog_agmi_sernr_old, agplog_agmi_sernr_new, agplog_agmi_allg1_old, agplog_agmi_allg1_new)
            VALUES ('UPDATE', auftg_r.ag_id, auftg_r.ag_nr, auftg_r.ag_pos, auftg_r.ag_pos,
                agmi_v_id_old, agmi_v_id_new, agmi_dat_old, agmi_dat_new, agmi_beistell_old, agmi_beistell_new,
                agmi_ld_auftg_old, agmi_ld_auftg_new, agmi_sernr_old, agmi_sernr_new, agmi_allg1_old, agmi_allg1_new);
        END IF;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER auftgmatinfo__a_u_log
    AFTER UPDATE
    ON auftgmatinfo
    FOR EACH ROW
    EXECUTE PROCEDURE auftgmatinfo__a_u_log();
--

--
CREATE TABLE artikelprognose
 (apr_id                SERIAL PRIMARY KEY,
  apr_jahr              INTEGER NOT NULL,
  apr_ad_krz            VARCHAR(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,  -- Kunde
  --  ak_ac             VARCHAR(9) NOT NULL,                                    -- Produktgruppe
  apr_ak_nr             VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE,  -- Artikel
  apr_me_01             NUMERIC(12,4),                                          -- Menge Januar
  apr_st_01             VARCHAR(1) CHECK((apr_me_01 ISNULL) = (apr_st_01 ISNULL)),  -- Status Januar
  apr_me_02             NUMERIC(12,4),
  apr_st_02             VARCHAR(1) CHECK((apr_me_02 ISNULL) = (apr_st_02 ISNULL)),
  apr_me_03             NUMERIC(12,4),
  apr_st_03             VARCHAR(1) CHECK((apr_me_03 ISNULL) = (apr_st_03 ISNULL)),
  apr_me_04             NUMERIC(12,4),
  apr_st_04             VARCHAR(1) CHECK((apr_me_04 ISNULL) = (apr_st_04 ISNULL)),
  apr_me_05             NUMERIC(12,4),
  apr_st_05             VARCHAR(1) CHECK((apr_me_05 ISNULL) = (apr_st_05 ISNULL)),
  apr_me_06             NUMERIC(12,4),
  apr_st_06             VARCHAR(1) CHECK((apr_me_06 ISNULL) = (apr_st_06 ISNULL)),
  apr_me_07             NUMERIC(12,4),
  apr_st_07             VARCHAR(1) CHECK((apr_me_07 ISNULL) = (apr_st_07 ISNULL)),
  apr_me_08             NUMERIC(12,4),
  apr_st_08             VARCHAR(1) CHECK((apr_me_08 ISNULL) = (apr_st_08 ISNULL)),
  apr_me_09             NUMERIC(12,4),
  apr_st_09             VARCHAR(1) CHECK((apr_me_09 ISNULL) = (apr_st_09 ISNULL)),
  apr_me_10             NUMERIC(12,4),
  apr_st_10             VARCHAR(1) CHECK((apr_me_10 ISNULL) = (apr_st_10 ISNULL)),
  apr_me_11             NUMERIC(12,4),
  apr_st_11             VARCHAR(1) CHECK((apr_me_11 ISNULL) = (apr_st_11 ISNULL)),
  apr_me_12             NUMERIC(12,4),                                          -- Menge Dezember
  apr_st_12             VARCHAR(1) CHECK((apr_me_12 ISNULL) = (apr_st_12 ISNULL)),  -- Status Dezember
  CONSTRAINT kunde_artikel_jahr UNIQUE(apr_jahr, apr_ak_nr, apr_ad_krz)
 );


CREATE OR REPLACE FUNCTION artikelprognose__a_iud() RETURNS TRIGGER AS $$
    DECLARE bestanftxtnr    VARCHAR;
            _m              VARCHAR;
            _sql            VARCHAR;
            I               INTEGER;
            doit            BOOL;
    BEGIN
     IF tg_op IN ('INSERT', 'UPDATE') THEN
            PERFORM execution_code__disable( _flagname => 'bedarfberech' );
            FOR i IN 1..12 LOOP
                    _m:=lpad(i, 2, '0');
                    bestanftxtnr:='PROG '||new.apr_jahr||'-'||_m;
                    --durch Tabellenstruktur muß geprüft werden, welches der Felder sich geändert hat, damit nicht sinnlos jedesmal jeder Monat ausgelöst wird, wenn ein Folgemonat eingetragen wird!
                    IF tg_op='INSERT' THEN
                            doit:=TRUE;
                    ELSE
                    CASE WHEN i=1 THEN
                            doit:=new.apr_me_01 IS DISTINCT FROM old.apr_me_01;
                         WHEN i=2 THEN
                            doit:=new.apr_me_02 IS DISTINCT FROM old.apr_me_02;
                         WHEN i=3 THEN
                            doit:=new.apr_me_03 IS DISTINCT FROM old.apr_me_03;
                         WHEN i=4 THEN
                            doit:=new.apr_me_04 IS DISTINCT FROM old.apr_me_04;
                         WHEN i=5 THEN
                            doit:=new.apr_me_05 IS DISTINCT FROM old.apr_me_05;
                         WHEN i=6 THEN
                            doit:=new.apr_me_06 IS DISTINCT FROM old.apr_me_06;
                         WHEN i=7 THEN
                            doit:=new.apr_me_07 IS DISTINCT FROM old.apr_me_07;
                         WHEN i=8 THEN
                            doit:=new.apr_me_08 IS DISTINCT FROM old.apr_me_08;
                         WHEN i=9 THEN
                            doit:=new.apr_me_09 IS DISTINCT FROM old.apr_me_09;
                         WHEN i=10 THEN
                            doit:=new.apr_me_10 IS DISTINCT FROM old.apr_me_10;
                         WHEN i=11 THEN
                            doit:=new.apr_me_11 IS DISTINCT FROM old.apr_me_11;
                         WHEN i=12 THEN
                            doit:=new.apr_me_12 IS DISTINCT FROM old.apr_me_12;
                    END CASE;
                    END IF;
                    --
            --achtung: bei Änderungen muß DailyDBFunctions.PrognosenAktualisieren angepasst werden!
            -- auftg__a_iu__doprognose
            -- ldsdok__a_iu__doprognose
                    _sql:='SELECT tplanterm.artikel_prognose_from_auftrag(apr_ak_nr, apr_me_'||_m||', apr_ad_krz||'' ~ ''||apr_ak_nr, 0, CAST(''01.'||_m||'.''||apr_jahr AS DATE), '''||bestanftxtnr||''', NULL::INTEGER, NULL::INTEGER, apr_ad_krz) FROM artikelprognose WHERE apr_id='||new.apr_id||' AND COALESCE(apr_me_'||_m||',0)<>0';
                    --
                    IF doit THEN
                            --EXECUTE _sql;
                    END IF;
            END LOOP;
            PERFORM execution_code__enable( _flagname => 'bedarfberech' );
            --PERFORM do_artikel_bedarf();
     END IF;
     --
     RETURN new;
    END $$ LANGUAGE plpgsql;


    CREATE TRIGGER artikelprognose__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON artikelprognose
    FOR EACH ROW
    EXECUTE PROCEDURE artikelprognose__a_iud();

    --- #9383
    CREATE OR REPLACE FUNCTION tauftg.auftg__ag_id__min__ag_pos__by__ag_dokunr(IN _ag_dokunr INTEGER, IN _ag_done BOOL DEFAULT FALSE) RETURNS INTEGER AS $$
      SELECT COALESCE( (  SELECT ag_id
                      FROM auftg
                      WHERE ag_dokunr = _ag_dokunr
                        AND CASE
                              WHEN _ag_done THEN ag_done     -- geschlossene Pos.
                              WHEN NOT _ag_done THEN NOT ag_done   -- offene Pos.
                            END
                      ORDER BY ag_pos LIMIT 1), 0);
      $$ LANGUAGE sql STABLE;

    CREATE OR REPLACE FUNCTION tauftg.auftgdokzahlplan__azp_id__min__azp_nr_by__ag_dokunr(IN _azp_atd_dokunr INTEGER) RETURNS INTEGER AS $$
       SELECT COALESCE( (SELECT azp_id FROM auftgdokzahlplan WHERE azp_atd_dokunr = _azp_atd_dokunr AND azp_be_bnr IS NULL ORDER BY azp_nr LIMIT 1), 0);
     $$ LANGUAGE sql STABLE;
    ---
    --- #11776 Verkaufspreis-Statistik
    CREATE OR REPLACE FUNCTION tauftg.ag_ep_netto__ag_bdat__PreisAnalyse(IN _agaknr VARCHAR, IN _ag_lkn VARCHAR DEFAULT '%', IN _danf DATE DEFAULT current_date, IN _dend DATE DEFAULT current_date, OUT ag_aknr VARCHAR, OUT ak_bez VARCHAR,
            OUT ag_ep_preis_erstes_verkaufdat DATE, OUT ag_ep_preis_letztes_verkaufdat DATE, OUT ag_ep_netto NUMERIC(16,4), OUT dif_month INTEGER) RETURNS SETOF RECORD AS $$
      DECLARE rec          RECORD;
          agepnetto  NUMERIC(16, 4);
          aknr    VARCHAR := '';
          akbez    VARCHAR := '';
          return_next  BOOLEAN := false;
      BEGIN
        agepnetto := -1;
        FOR rec IN (SELECT ag_id,
              auftg.ag_aknr,
              art.ak_bez,
              auftg.ag_bdat,
              auftg.ag_ep_netto
            FROM auftg
              JOIN art ON ak_nr = auftg.ag_aknr
            WHERE ag_astat = 'E'
              AND auftg.ag_bdat BETWEEN _danf AND _dend AND auftg.ag_bdat IS NOT NULL
              AND auftg.ag_lkn LIKE _ag_lkn
              AND auftg.ag_aknr = _agaknr
            ORDER BY auftg.ag_bdat) LOOP

        ag_aknr := rec.ag_aknr;
        ak_bez := rec.ak_bez;
        ag_ep_netto := rec.ag_ep_netto;

        IF aknr <> rec.ag_aknr AND agepnetto <> -1 THEN
            ag_aknr := aknr;
            ak_bez := akbez;
            ag_ep_netto := agepnetto;
            RETURN NEXT;
            aknr := '';
            akbez := '';
            agepnetto := -1;
            ag_ep_preis_erstes_verkaufdat := null;
            ag_ep_preis_letztes_verkaufdat := null;
        END IF;

        IF (agepnetto <> rec.ag_ep_netto OR aknr <> rec.ag_aknr) AND agepnetto <> -1 AND aknr <> ''  THEN
            IF aknr = rec.ag_aknr THEN
                IF rec.ag_bdat > ag_ep_preis_erstes_verkaufdat THEN
                    ag_ep_preis_letztes_verkaufdat := rec.ag_bdat - 1;
                ELSE
                ag_ep_preis_letztes_verkaufdat := rec.ag_bdat;
                END IF;
            END IF;
            ag_ep_netto := agepnetto;
            dif_month := (DATE_PART('year', COALESCE(ag_ep_preis_letztes_verkaufdat, current_date)) - DATE_PART('year', ag_ep_preis_erstes_verkaufdat)) * 12
                + (DATE_PART('month', COALESCE(ag_ep_preis_letztes_verkaufdat, current_date)) - DATE_PART('month', ag_ep_preis_erstes_verkaufdat)) + 1;
            RETURN NEXT;
            return_next := false;
            ag_ep_preis_erstes_verkaufdat := rec.ag_bdat;
            ag_ep_preis_letztes_verkaufdat := null;
        END IF;

        IF agepnetto <>rec.ag_ep_netto  THEN
            ag_ep_preis_erstes_verkaufdat := rec.ag_bdat;
        END IF;

        agepnetto := rec.ag_ep_netto;
        aknr := rec.ag_aknr;
        akbez := rec.ak_bez;
        dif_month := (DATE_PART('year', COALESCE(ag_ep_preis_letztes_verkaufdat, current_date)) - DATE_PART('year', ag_ep_preis_erstes_verkaufdat)) * 12
                + (DATE_PART('month', COALESCE(ag_ep_preis_letztes_verkaufdat, current_date)) - DATE_PART('month', ag_ep_preis_erstes_verkaufdat)) + 1;
        END LOOP;
        RETURN NEXT;
      END $$ LANGUAGE plpgsql;
--

